unit MAIN;

//       
//    ,      
//  .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons,
  Service1, Service3;

type
  TForm1 = class(TForm)
    Label2: TLabel;
    Image1: TImage;
    Bevel3: TBevel;
    Timer1: TTimer;
    CheckBox2: TCheckBox;
    Bevel1: TBevel;
    ComboBox2: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    Bevel4: TBevel;
    Panel1: TPanel;
    CBoxEnCapt: TCheckBox;
    CBoxEnVGrid: TCheckBox;
    CBoxEnHGrid: TCheckBox;
    Edit1: TEdit;
    CBoxEnCurrY: TCheckBox;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    CbBoxSens: TComboBox;
    Label1: TLabel;
    CbBoxMdHold: TComboBox;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ComboBox2Click(Sender: TObject);
    procedure CBoxEnCaptClick(Sender: TObject);
    procedure CBoxEnHGridClick(Sender: TObject);
    procedure CBoxEnVGridClick(Sender: TObject);
    procedure CBoxEnCurrYClick(Sender: TObject);
    procedure CbBoxSensClick(Sender: TObject);
    procedure CbBoxMdHoldClick(Sender: TObject);

  private
    { Private declarations }
    procedure DDisplayOnItemDraw (Sender : TObject; X, Y : integer;
                                  Item   : TQItem);
    procedure DDisplayOnLargItem (Sender : TObject; X, Y : integer;
                                  Item : TQItem);
  public
    { Public declarations }
  end;

var
       Form1: TForm1;

//     ()

const  NumPoint =  20;                  //     
       Omega    =  2 * Pi / NumPoint;   //  

var    Point    : integer;              //   
       Module   : integer;              //  
       YPoint   : double;               //    
       RunFlag  : boolean;              //   

implementation

{$R *.dfm}

// ===========================================================
var DDisplay  : TDDisplay;  //   
// ===========================================================
//  
procedure TForm1.FormCreate(Sender: TObject);
begin
   RunFlag := False;
   Point   := 0;
   Module  := 40;
   Randomize;
end;

//     
procedure TForm1.FormDestroy(Sender: TObject);
begin
  RunFlag := False;
  if Assigned(DDisplay) then DDisplay.Free;
end;
// -----------------------------------------------------------
//  
procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
   //     
   if not Assigned(DDisplay)
   then begin
       DDisplay := TDDisplay.Create(Image1);
       //    -   
       DDisplay.OnLargItem := DDisplayOnLargItem;
       RunFlag := True;    //  
   end;
end;
//   
procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  if Assigned(DDisplay)
  then begin
     RunFlag := False;     //  
     DDisplay.Free;        //  
     DDisplay := nil;
  end;
end;
// -----------------------------------------------------------
//    
// -   
procedure TForm1.CBoxEnCaptClick(Sender: TObject);
begin
  if Assigned(DDisplay)
  then DDisplay.EnCapt := CBoxEnCapt.Checked;
end;
// -   
procedure TForm1.CBoxEnHGridClick(Sender: TObject);
begin
  if Assigned(DDisplay)
  then DDisplay.EnHGrid := CBoxEnHGrid.Checked;
end;
// -   
procedure TForm1.CBoxEnVGridClick(Sender: TObject);
begin
  if Assigned(DDisplay)
  then DDisplay.EnVGrid := CBoxEnVGrid.Checked;
end;
//   (   )
procedure TForm1.CbBoxSensClick(Sender: TObject);
begin
  if Assigned(DDisplay)
  then begin
     case CbBoxSens.ItemIndex of
     0 : DDisplay.Sens := 10;
     1 : DDisplay.Sens := 20;
     2 : DDisplay.Sens := 50;
     3 : DDisplay.Sens := 100;
     end;
  end;
end;
//      
procedure TForm1.CbBoxMdHoldClick(Sender: TObject);
begin
  if Assigned(DDisplay)
  then begin
     case CbBoxMdHold.ItemIndex of
     0 : DDisplay.MdHold := -1;
     1 : DDisplay.MdHold := 0.7 * Module;
     2 : DDisplay.MdHold := 0.8 * Module;
     3 : DDisplay.MdHold := 0.9 * Module;
     end;
  end;
end;
// -----------------------------------------------------------
//    
//  -       TEdit
procedure TForm1.CBoxEnCurrYClick(Sender: TObject);
begin
 if Assigned(DDisplay)
 then begin
    if CBoxEnCurrY.Checked
    then DDisplay.OnDrawItem := DDisplayOnItemDraw
    else DDisplay.OnDrawItem := NIL;
 end;
end;
// -----------------------------------------------------------
//   ,     TDDisplay
//   -   
procedure TForm1.DDisplayOnItemDraw (Sender : TObject;
     X, Y : integer; Item : TQItem);
begin
  Edit1.Text := FormatFloat('#0.000000', Item.RData);
end;
//   -   
procedure TForm1.DDisplayOnLargItem (Sender : TObject;
     X, Y : integer; Item : TQItem);
begin
  //    (440 hz)   
  Windows.Beep(440,50);  //  (hz),  (ms)
end;

// ===========================================================
//     
// ===========================================================
//    
procedure TForm1.ComboBox2Click(Sender: TObject);
begin
  case ComboBox2.ItemIndex of
  0 : Module := 40;
  1 : Module := 60;
  2 : Module := 80;
  3 : Module := 100;
  4 : Module := 120;
  end;
end;

//  
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if RunFlag
  then begin
     //     
     YPoint := Module * Sin(Omega * Point);
     //    
     if CheckBox2.Checked
     then YPoint := YPoint + Random(Module div 3);
     // -----------------------------------------
     //    
     //      
     DDisplay.AddItemToTail(0, YPoint);
     DDisplay.ShowItemQueue();
     // -----------------------------------------
     //     
     Point := Point + 1;
     if Point > NumPoint then Point := 0;
  end;
end;

end.
